<%@ control language="C#" autoeventwireup="true" inherits="Eprint.Skyline.Web.Controls.Products, App_Web_ufq0pyog" %>
<%@ Register TagPrefix="ajaxToolkit" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit, Version=3.5.51116.0, Culture=neutral, PublicKeyToken=28f01b0e84b6d53e" %>
<asp:HiddenField runat="server" ID="hidId" />
<asp:HiddenField runat="server" ID="hidCategoryId"/>
<asp:HiddenField runat="server" ID="HidGlobal"/>

<telerik:RadAjaxManager runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="rptPortalProducts">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="rptPortalProducts" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManager>
<asp:Label ID="ProductCannotBeDeletedLabel" runat="server" CssClass="error" Text="This Product is assigned to a portal so cannot be deleted"
    Visible="False" EnableViewState="false"></asp:Label>

<asp:Label runat="server" ID="NoProductsAvailableLabel" Text="There are no products available"
    EnableViewState="false" Visible="false"></asp:Label>
<asp:Repeater runat="server" ID="rptPortalProducts" OnItemDataBound="rptPortalProducts_ItemDataBound">
    <ItemTemplate>
        <div class="descblock">
        </div>
        <asp:Panel runat="server" ID="pnlProduct" Width="100%">
            <div class="select-product">
                <table width="100%" cellspacing="5">
                    <tr>
                        <td style="width: 150px" align="center" valign="top">
                            <asp:Label runat="server" ID="lblProductGuid" Visible="false" Text='<%# DataBinder.Eval ( Container.DataItem, "ProductId") %>' />
                            <asp:ImageButton CausesValidation="false" runat="server" ID="imgProductImg" ImageUrl='<%# String.Format("~/Images/Products/{0}", DataBinder.Eval ( Container.DataItem, "Image")) %>'
                                CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "ProductId") %>'
                                OnCommand="Proceed" />
                        </td>
                        <td valign="top">
                            <strong>
                                <%# DataBinder.Eval(Container.DataItem, "Name")%></strong>
                            <div class="WarningLabel">
                                <asp:Label runat="server" ID="WarningLabel" Visible="false" Text='<%# Eprint.Skyline.Translations.Website.IncompatibleProduct %>' /></div>
                            <%# DataBinder.Eval ( Container.DataItem, "Description") %>
                        </td>
                        <td style="width: 100px" align="Left">
                            <table cellpadding="2" cellspacing="0">
                                <tr>
                                    <td align="left">
                                        <telerik:RadButton runat="server" Visible='<%# ShowProceed %>' ID="UxButtonProceed"
                                            Text="Proceed" OnCommand="Proceed" Skin="Office2010Silver" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "ProductId") %>'>
                                            <Icon SecondaryIconUrl="~/images/next.png" SecondaryIconTop="3px" SecondaryIconRight="3px">
                                            </Icon>
                                        </telerik:RadButton>
                                    </td>
                                    <td align="left">
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left">
                                        <asp:HyperLink Visible='<%# ShowEdit %>' runat="server" ID="imgEdit" ImageUrl="~/images/Edit.gif"
                                            NavigateUrl='<%# String.Format("~/Admin/Product.aspx?pid={0}", DataBinder.Eval ( Container.DataItem, "ProductId")) %>' />
                                    </td>
                                    <td align="left">
                                        <asp:Label ID="ProductsShowEditLabel" Visible='<%# ShowEdit %>' runat="server">Edit</asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left">
                                        <asp:ImageButton Visible='<%# ShowMoveUp((int)DataBinder.Eval ( Container.DataItem, "DisplayOrder")) %>'
                                            CausesValidation="false" runat="server" ID="imgMoveUp" OnCommand="MoveUp" ImageUrl="~/images/ArrowU.gif"
                                            CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "ProductId")  + "," +  DataBinder.Eval ( Container.DataItem, "DisplayOrder") %>' />
                                    </td>
                                    <td align="left">
                                        <asp:Label ID="ProductsMoveUpLabel" Visible='<%# ShowMoveUp((int)DataBinder.Eval ( Container.DataItem, "DisplayOrder")) %>'
                                            runat="server"><%=Eprint.Skyline.Translations.Website.MoveUp %></asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left">
                                        <asp:ImageButton ID="btn1" ImageUrl="~/Images/Delete.gif" Width="14" Height="14"
                                            runat="server" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "ProductId") %>'
                                            OnCommand="confirmButton_Clicked" Visible='<%# ShowDelete %>' />
                                        <ajaxToolkit:ConfirmButtonExtender ID="cfe1" runat="server" TargetControlID="btn1"
                                            ConfirmText="Delete the selected item.  Are You Sure?" />
                                        <%--                                    <epc:ConfirmButton ID="confirmButton" runat="server" Type="Image" Message="Delete the selected item.  Are You Sure?"
                                        ImageUrl="~/Images/Delete.gif" AlternativeText="Delete" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "Product.ProductId") %>'
                                        Visible='<%# ShowDelete %>' Text="Delete" ToolTip="Delete" OnClick="confirmButton_Clicked">
                                    </epc:ConfirmButton>--%>
                                    </td>
                                    <td align="left">
                                        <asp:Label ID="ProductsRemoveLabel" Visible='<%# ShowDelete %>' runat="server"><%=Eprint.Skyline.Translations.Common.Remove %></asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="left">
                                        <asp:ImageButton Visible='<%# ShowMoveDown((int)DataBinder.Eval ( Container.DataItem, "DisplayOrder")) %>'
                                            CausesValidation="false" runat="server" ID="imgMoveDown" OnCommand="MoveDown"
                                            ImageUrl="~/images/ArrowD.gif" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "ProductId") + "," + DataBinder.Eval ( Container.DataItem, "DisplayOrder") %>' />
                                    </td>
                                    <td align="left">
                                        <asp:Label ID="ProductsMoveDownLabel" Visible='<%# ShowMoveDown((int)DataBinder.Eval ( Container.DataItem, "DisplayOrder")) %>'
                                            runat="server"><%=Eprint.Skyline.Translations.Website.MoveDown %></asp:Label>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </div>
        </asp:Panel>
    </ItemTemplate>
</asp:Repeater>

