﻿<%@ page title="" language="C#" masterpagefile="~/MasterPage.master" autoeventwireup="true" inherits="Vpress_VPressEditor, App_Web_ug4nijop" enableEventValidation="false" %>

<%@ MasterType VirtualPath="~/MasterPage.master" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <script src="https://nodeserver.coreprint.net/public-test/redirect/vpress-embedded-tech-v3-test.js"></script>

    <style type="text/css">
        html.no-scroll, body.no-scroll {
            height: 100%;
            overflow: hidden;
        }

        html.no-scroll {
            padding-right: 0px;
        }

        .hide-modal {
            display: none !important;
        }

        @media only screen and (max-width: 768px) {
            html, body {
                overflow-y: auto;
            }
        }
    </style>
    <div style="text-align: center;">
        <img src="/vpress/images/editor-preview.png" alt="Editor Preview" style="max-width: 100%; height: auto; display: block; margin: 0 auto 20px;" />

        <asp:Button ID="Button1" runat="server" Text="Launch Editor" OnClientClick="loadCoreprintModal(event); return false;" CssClass="personalise-button" />
    </div>
    <img src="/vpress/images/editor-preview.png" alt="Editor Preview" style="max-width: 100%; height: auto;" />

    <asp:Button ID="LaunchEditorButton" runat="server" Text="Launch Editor" OnClientClick="loadCoreprintModal(event); return false;" CssClass="personalise-button" />

    <div id="editor-container" class="hide-modal" style="position: fixed; height: 100vh; width: 100vw; left: 0; top: 0; z-index: 9999999; pointer-events: none;"></div>

    <script type="text/javascript">

        const initialToken = "<%= InitialToken %>";
        const productId = "<%= ProductId %>";

        let zoidloaded = false;

        function loadCoreprintModal(e) {
            if (e) {
                e.preventDefault();
            }

            if (!zoidloaded) {
                VpressEditorComponent({
                    loginToken: initialToken,
                    productId: productId,
                    userId: "modal@coreprint.net",
                    documentId: null,
                    snapshot: null,
                    config: {
                        options: {
                            advanced: false,
                            hideSplash: true,
                            hideToolbar: false,
                            pinPages: false,
                            pinLayers: false,
                            hideMobileToolbar: true,
                            formFill: true,
                            hidePdfDownload: false,
                            forceSaveOnFinish: false,
                            hideIntructions: false,
                            showArchive: false
                        },
                        translations: {
                            title: "Example title",
                            subTitle: "Example subtitle",
                            instructionsStart: "This page has",
                            instructionsEnd: "editable field(s).",
                            labelOpen: "Open",
                            labelSave: "Save",
                            labelCancel: "Close",
                            labelFinish: "Finish",
                            labelNext: "Next",
                            labelPrevious: "Previous",
                            labelProofTitle: "Proof",
                            labelRefreshProof: "Refresh Proof",
                            labelFieldsTitle: "Editable fields",
                            labelFileName: "Filename",
                            labelSaveName: "Untitled",
                            labelSaveAlert: "Please enter a valid name"
                        },
                        logo: {
                            url: "https://www.vpress.com/wp-content/uploads/2018/06/vpress-logo-retina-1.png",
                            height: "30px"
                        },
                        styles: {
                            borderRadius: "0px",
                            backgroundColor: "#f5f5f5",
                            headerBackgroundColor: "white",
                            headerTitleTextColor: "#E8540D",
                            headerSubTitleTextColor: "#E8540D",
                            headerButtonTextColor: "#363636",
                            headerButtonBackgroundColor: "white",
                            headerButtonBorderColor: "#dddddd",
                            headerButtonBorderStyle: "solid",
                            headerButtonBorderWidth: "1px",
                            headerButtonBorderRadius: "5px",
                            cardBackgroundColor: "white",
                            cardBorderColor: "#f0f0f0",
                            cardBorderWidth: "1px",
                            cardBorderRadius: "5px",
                            cardBorderStyle: "solid",
                            cardHeaderBackgroundColor: "white",
                            fieldBackgroundColor: "white",
                            fieldTextColor: "#363636",
                            fieldHeight: "50px",
                            fieldLabelColor: "#363636",
                            fieldBorderColor: "#dddddd",
                            fieldBorderWidth: "1px",
                            fieldBorderStyle: "solid",
                            fieldBorderRadius: "4px",
                            fieldPlaceholderColor: "rgba(54,54,54,.3)",
                            primaryButtonBackgroundColor: "#E8540D",
                            primaryButtonTextColor: "#ffffff",
                            instructionsBackgroundColor: "#fef5f0"
                        }
                    },
                    closeModal: function () {
                        hideModal();
                    },
                    //returnJSON: function (jsonData) {
                    //    //updatePageWithData(jsonData);
                    //    handleReturnJSON;
                    //},
                    returnJSON: handleReturnJSON,
                    returnBase64Proof: function (imgData, pageNumber) { },
                    loadingProofStarted: function () { },
                    loadingProofComplete: function () { },
                    appReady: function () { }
                }).render("#editor-container");

                zoidloaded = true;
                showModal();
            } else {
                showModal();
            }
        }

        function showModal() {
            document.getElementById("editor-container").style.pointerEvents = "all";
            document.body.classList.add("no-scroll");
            document.documentElement.classList.add("no-scroll");
            document.getElementById("editor-container").classList.remove("hide-modal");
        }

        function hideModal() {
            document.getElementById("editor-container").style.pointerEvents = "none";
            document.body.classList.remove("no-scroll");
            document.documentElement.classList.remove("no-scroll");
            document.getElementById("editor-container").classList.add("hide-modal");
        }

        function updatePageWithData(jsonData) {
            const btn = document.getElementById("<%= LaunchEditorButton.ClientID %>");
            btn.value = JSON.stringify(jsonData);
            hideModal();
        }

        
        function handleReturnJSON(jsonData) {
            const jsonString = JSON.stringify(jsonData);
            
            // Create a new form
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = 'AddBasketEntry.aspx'; 
            form.style.display = 'none';

            // JSON data field
            const jsonField = document.createElement('input');
            jsonField.type = 'hidden';
            jsonField.name = 'jsonData';
            jsonField.value = jsonString;
            form.appendChild(jsonField);

            // Token field
            const tokenField = document.createElement('input');
            tokenField.type = 'hidden';
            tokenField.name = 'initialToken';
            tokenField.value = initialToken;
            form.appendChild(tokenField);

            // Product ID field 
            const productField = document.createElement('input');
            productField.type = 'hidden';
            productField.name = 'productId';
            productField.value = productId;
            form.appendChild(productField);

            // Append and submit the form
            document.body.appendChild(form);
            form.submit();
        }


    </script>
</asp:Content>

