<%@ page language="C#" masterpagefile="~/MasterPage.master" autoeventwireup="true" inherits="Eprint.Skyline.Web.Pages.UserAdmin_Libraries, App_Web_azu3o4ht" enableEventValidation="false" %>

<%@ Import Namespace="Eprint.Skyline.Translations" %>
<%@ MasterType VirtualPath="~/MasterPage.master" %>
<%--<%@ Register TagPrefix="ajaxToolkit" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit, Version=3.5.51116.0, Culture=neutral, PublicKeyToken=28f01b0e84b6d53e" %>--%>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <link href="../css/products.css" rel="stylesheet" type="text/css" />
    <link href="../css/fullpage.css" rel="stylesheet" type="text/css" />
    
    <h3>
        <asp:Label ID="LibrariesHeader" runat="server">Manage Personal Libraries</asp:Label>
    </h3>
    <div>
        <div>
            <asp:Label ID="AddLibraryInfo" runat="server" CssClass="title12 library-header">Add a new library</asp:Label>
        </div>
        <div class="library-name">
            <asp:Label ID="LibraryNameLabel" runat="server">Library Name</asp:Label>
        </div>
        <div class="library-name-textbox">
            <telerik:RadTextBox runat="server" ID="txtName" ValidationGroup="Add" Style="width: 200px"
                MaxLength="30" /><asp:RequiredFieldValidator ID="RFVLib" runat="server" ControlToValidate="txtName"
                    ValidationGroup="Add" ErrorMessage="*"></asp:RequiredFieldValidator>
        </div>
        <div class="library-name-button">
            <asp:Button runat="server" ID="btnAdd" Text="Add" OnClick="btnAdd_Click" ValidationGroup="Add" />
        </div>
    </div>
    <div class="error-messages">
        <asp:Label ID="mustHaveLibraryLabel" runat="server" Text="You must have at least one library"
            Visible="false" />
        <asp:Label runat="server" ID="DefaultLibraryError" CssClass="error" Visible="false"
            EnableViewState="false"></asp:Label>
        <asp:Label runat="server" ID="CannotDeleteDefaultLibraryError" CssClass="error" Visible="false"
            EnableViewState="false"></asp:Label>
        <br />
    </div>
    <br />
    <div>
        <asp:Image ID="Image1" runat="server" ImageUrl="../images/Library.png" ImageAlign="AbsMiddle" />
        <asp:Label ID="PersonalLibrariesHeaderLabel" runat="server" CssClass="shared-libraries-title">My Personal Libraries</asp:Label></div>
    
    <telerik:RadGrid ID="grdLibraries" runat="server" OnNeedDataSource="grdLibraries_NeedDataSource"
        OnUpdateCommand="grdLibraries_UpdateCommand">
        <MasterTableView AutoGenerateColumns="false" GridLines="none" EditMode="InPlace"
            DataKeyNames="LibraryId">
            <Columns>
                <telerik:GridEditCommandColumn EditImageUrl="../images/Edit.gif" UpdateImageUrl="../images/save.gif"
                    CancelImageUrl="../images/delete.gif" ButtonType="ImageButton" />
                <telerik:GridBoundColumn DataField="Name" UniqueName="Name" HeaderText="Library Name"
                    MaxLength="30" />
                <telerik:GridTemplateColumn UniqueName="AddToCatalogs">
                    <ItemTemplate>
                        <asp:Panel runat="server" ID="pnl" Visible='<%# !(bool)DataBinder.Eval ( Container.DataItem, "IsDefault") %>'>
                            <a href='Library.aspx?lid=<%# DataBinder.Eval ( Container.DataItem, "LibraryId").ToString() %>'>
                                <%# Website.AddToCatalogues%></a>
                        </asp:Panel>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn UniqueName="IsDefault" HeaderText="Default" ItemStyle-HorizontalAlign="Center"
                    HeaderStyle-HorizontalAlign="Center" ItemStyle-Width="30px" HeaderStyle-Width="30px">
                    <ItemTemplate>
                        <asp:CheckBox ID="IsDefaultCB" runat="server" Enabled="false" Checked='<%#  (bool)DataBinder.Eval ( Container.DataItem, "IsDefault")%>' />
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:CheckBox ID="IsDefaultCB" runat="server" Checked='<%# (bool)DataBinder.Eval ( Container.DataItem, "IsDefault")%>' />
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn>
                    <ItemStyle Width="12px" />
                    <ItemTemplate>
                        <asp:ImageButton ID="btn1" ImageUrl="~/Images/Admin Icons/delete16.png" Width="14" Height="14"
                            runat="server" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "LibraryId") %>'
                            OnClientClick="javascript:if(!confirm('This action will delete the selected library and all of the documents in it. Are you sure?')){return false;}"
                            OnCommand="confirmButton_Clicked" Visible="True" />
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>
        </MasterTableView>
    </telerik:RadGrid><br />
    <br />
    <asp:Panel ID="catalogPanel" runat="server">
        <div>
            <asp:Image runat="server" ImageUrl="../images/LibraryS.png" ImageAlign="AbsMiddle" />
            <asp:Label ID="CataloguesHeaderLabel" runat="server" CssClass="shared-libraries-title">My Catalogues</asp:Label></div>
        <telerik:RadGrid ID="SharedLibraries" runat="server" OnNeedDataSource="SharedLibraries_NeedDataSource"
            OnUpdateCommand="SharedLibraries_UpdateCommand">
            <MasterTableView AutoGenerateColumns="false" GridLines="none" EditMode="InPlace"
                DataKeyNames="LibraryId">
                <Columns>
                    <telerik:GridEditCommandColumn EditImageUrl="../images/Edit.gif" UpdateImageUrl="../images/save.gif"
                        CancelImageUrl="../images/delete.gif" ButtonType="ImageButton" />
                    <telerik:GridBoundColumn DataField="Name" UniqueName="Name" HeaderText="Catalogue Name"
                        MaxLength="30" />
                    <telerik:GridTemplateColumn>
                        <ItemTemplate>
                            <a href='Library.aspx?lid=<%# DataBinder.Eval ( Container.DataItem, "LibraryId").ToString() %>'>
                                <%# Website.ManageCataloguePermissions %></a>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridCheckBoxColumn DataField="AllUsersHaveFullControl" ItemStyle-HorizontalAlign="Center"
                        HeaderStyle-HorizontalAlign="Center" UniqueName="AllUsersHaveFullControl" HeaderText="All users have full control"
                        Visible="False">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridTemplateColumn>
                        <ItemStyle Width="12px" />
                        <ItemTemplate>
                            <asp:ImageButton ID="btn1" ImageUrl="~/Images/Admin Icons/delete16.png" Width="14" Height="14"
                                runat="server" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "LibraryId") %>'
                                OnClientClick="javascript:if(!confirm('This action will delete the selected library and all of the documents in it. Are you sure?')){return false;}"
                                OnCommand="confirmButton_Clicked" Visible="True" />
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                </Columns>
            </MasterTableView>
        </telerik:RadGrid>
    </asp:Panel>
    <br />
    <asp:Panel runat="server" ID="OtherSharedLibraries" Visible="false" CssClass="other-shared-libraries" >
        <div class="row">
            <asp:Image runat="server" ImageUrl="../images/library-users.png" ImageAlign="AbsMiddle" />
            <asp:Label runat="server" ID="UxLabelOtherSharedLibraries" Text="Shared libraries belonging to other users"
                CssClass="shared-libraries-title"></asp:Label>
        </div>
        <br/>
        <div class="row">
            <asp:Label runat="server" ID="UxLabelUserShared" Text="Shared to users" CssClass="shared-library-grid-title"></asp:Label>
        </div>
        <telerik:RadGrid runat="server" ID="OtherLibraries" OnNeedDataSource="OtherLibraries_OnNeedDataSource">
            <MasterTableView AutoGenerateColumns="false" GridLines="none">
                <Columns>
                    <telerik:GridBoundColumn DataField="LibraryName" UniqueName="LibraryName" HeaderText="Library Name"
                        MaxLength="30" />
                    <telerik:GridBoundColumn DataField="OwnerUsername" UniqueName="OwnerUsername" HeaderText="Owner Username"
                        MaxLength="30" />
                    <telerik:GridTemplateColumn>
                        <ItemTemplate>
                            <a href='Library.aspx?lid=<%# DataBinder.Eval ( Container.DataItem, "LibraryId").ToString() %>'>
                                <%# Website.ManageCataloguePermissions %></a>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                </Columns>
            </MasterTableView>
        </telerik:RadGrid>
        <br />
        <div class="row">
            <asp:Label runat="server" ID="UxLabelRolesShared" Text="Shared to user roles" CssClass="shared-library-grid-title"></asp:Label>
            <telerik:RadGrid runat="server" ID="RoleLibraries" 
                onneeddatasource="RoleLibraries_NeedDataSource" >
            <MasterTableView AutoGenerateColumns="false" GridLines="none">
                <Columns>
                    <telerik:GridBoundColumn DataField="LibraryName" UniqueName="LibraryName" HeaderText="Library Name"
                        MaxLength="30" />
                    <telerik:GridBoundColumn DataField="OwnerUsername" UniqueName="OwnerUsername" HeaderText="Owner Username"
                        MaxLength="30" />
                    <telerik:GridBoundColumn DataField="RoleName" UniqueName="RoleName" HeaderText="Role Name"
                                             MaxLength="30" />
                    <telerik:GridTemplateColumn>
                        <ItemTemplate>
                            <a href='Library.aspx?lid=<%# DataBinder.Eval ( Container.DataItem, "LibraryId").ToString() %>'>
                                <%# Website.ManageCataloguePermissions %></a>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                </Columns>
            </MasterTableView>
        </telerik:RadGrid>
        </div>
    </asp:Panel>
</asp:Content>
