<%@ page language="C#" autoeventwireup="true" inherits="AzureUserSelection, App_Web_1tnbu1lv" enableEventValidation="false" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Select Your Account</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 30px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 24px;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .email-info {
            background: #e8f4fd;
            border: 1px solid #b8daff;
            border-radius: 4px;
            padding: 12px;
            margin-bottom: 20px;
            color: #004085;
        }
        .user-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .user-item {
            border: 1px solid #ddd;
            border-radius: 4px;
            margin-bottom: 10px;
            padding: 15px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .user-item:hover {
            border-color: #007bff;
            background: #f8f9fa;
        }
        .user-item.selected {
            border-color: #007bff;
            background: #e7f1ff;
        }
        .user-name {
            font-weight: 600;
            color: #333;
            font-size: 16px;
        }
        .user-details {
            color: #666;
            font-size: 13px;
            margin-top: 5px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            font-size: 14px;
            font-weight: 600;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background 0.2s;
        }
        .btn-primary {
            background: #007bff;
            color: white;
        }
        .btn-primary:hover {
            background: #0056b3;
        }
        .btn-primary:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        .btn-secondary {
            background: #6c757d;
            color: white;
            margin-left: 10px;
        }
        .btn-secondary:hover {
            background: #545b62;
        }
        .button-row {
            margin-top: 20px;
            text-align: right;
        }
        .error-message {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 4px;
            padding: 12px;
            margin-bottom: 20px;
            color: #721c24;
        }
        .hidden {
            display: none;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="container">
            <h1>Multiple Accounts Found</h1>
            <p class="subtitle">Your email address is associated with multiple accounts. Please select the account you want to use.</p>
            
            <div class="email-info">
                <strong>Email:</strong> <asp:Label ID="lblEmail" runat="server"></asp:Label>
            </div>
            
            <asp:Label ID="lblError" runat="server" CssClass="error-message hidden"></asp:Label>
            
            <asp:HiddenField ID="hdnSelectedUserId" runat="server" />
            
            <asp:Repeater ID="rptUsers" runat="server">
                <HeaderTemplate>
                    <ul class="user-list">
                </HeaderTemplate>
                <ItemTemplate>
                    <li class="user-item" onclick="selectUser('<%# Eval("UserId") %>', this)">
                        <div class="user-name"><%# Eval("UserName") %></div>
                        <div class="user-details">
                            Last Login: <%# Eval("LastLoginDate") %>
                        </div>
                    </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
            
            <div class="button-row">
                <asp:Button ID="btnSelect" runat="server" Text="Link This Account" CssClass="btn btn-primary" 
                    OnClick="btnSelect_Click" OnClientClick="return validateSelection();" />
                <asp:Button ID="btnCancel" runat="server" Text="Cancel" CssClass="btn btn-secondary" 
                    OnClick="btnCancel_Click" CausesValidation="false" />
            </div>
        </div>
    </form>
    
    <script type="text/javascript">
        function selectUser(userId, element) {
            // Remove selected class from all items
            var items = document.querySelectorAll('.user-item');
            for (var i = 0; i < items.length; i++) {
                items[i].classList.remove('selected');
            }
            
            // Add selected class to clicked item
            element.classList.add('selected');
            
            // Set hidden field value
            document.getElementById('<%= hdnSelectedUserId.ClientID %>').value = userId;
        }
        
        function validateSelection() {
            var selectedId = document.getElementById('<%= hdnSelectedUserId.ClientID %>').value;
            if (!selectedId || selectedId === '') {
                alert('Please select an account to continue.');
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
