<%@ page language="C#" masterpagefile="~/MasterPage.master" enablesessionstate="True" autoeventwireup="true" inherits="Eprint.Skyline.Web.Pages.Admin.Admin_Portals, App_Web_lxy41nf5" enableEventValidation="false" %>

<%@ Register Src="~/WebControls/AdminHeader.ascx" TagName="AdminHeader" TagPrefix="ep" %>
<%@ MasterType VirtualPath="~/MasterPage.master" %>
<%@ Register Src="~/WebControls/AdminFooter.ascx" TagName="AdminFooter" TagPrefix="ep" %>
<%@ Register Assembly="SD.LLBLGen.Pro.ORMSupportClasses.NET20" Namespace="SD.LLBLGen.Pro.ORMSupportClasses"
    TagPrefix="llblgenpro" %>
<%@ Register TagPrefix="ajaxToolkit" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit, Version=3.5.51116.0, Culture=neutral, PublicKeyToken=28f01b0e84b6d53e" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <link href="../css/admin.css" rel="stylesheet" type="text/css" />
    <script language="javascript" type="text/javascript">
        function ChangeCursorToBusy(sender, eventArgs) {
            document.body.style.cursor = 'wait';

        }

        function ChangeCursorToDefault(sender, eventArgs) {
            document.body.style.cursor = 'default';
        }

    </script>
    <ep:AdminHeader ID="adminheader" runat="server" />
    <telerik:RadAjaxManager runat="server" ID="RadAjaxManager1" DefaultLoadingPanelID="RadAjaxLoadingPanel1">
    </telerik:RadAjaxManager>
    <telerik:RadAjaxLoadingPanel ID="RadAjaxLoadingPanel1" runat="server"
        BackgroundPosition="Top" Transparency="90" />
    <telerik:RadAjaxPanel ID="pnl" runat="server">
    </telerik:RadAjaxPanel>

        <telerik:RadGrid runat="server" ID="grdPortals" GridLines="none" AutoGenerateColumns="false"
            OnNeedDataSource="grdPortals_NeedDataSource" OnUpdateCommand="grdPortals_UpdateCommand"
            OnItemDataBound="grdPortal_ItemDataBound" enableajax="true" Skin="Office2010Silver">
            <MasterTableView EditMode="InPlace" DataKeyNames="PortalId,HTTPS">
                <SortExpressions>
                    <telerik:GridSortExpression FieldName="PortalName" SortOrder="Ascending" />
                </SortExpressions>
                <Columns>
                    <telerik:GridEditCommandColumn EditImageUrl="../Images/Edit.gif" ButtonType="imagebutton"
                        UpdateImageUrl="../Images/SAve.gif" CancelImageUrl="../Images/Delete.gif">
                        <ItemStyle Width="30px" />
                    </telerik:GridEditCommandColumn>
                    <telerik:GridTemplateColumn HeaderText="Portal" UniqueName="Portal">
                        <ItemStyle Width="12px" />
                        <ItemTemplate>
                            <%# GetPortalDetails(DataBinder.Eval (Container.DataItem, "PortalName").ToString() ,new Guid(DataBinder.Eval ( Container.DataItem, "PortalId" ).ToString())) %>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridBoundColumn DataField="PortalName" HeaderText="Portal Name" ReadOnly="true"
                        UniqueName="PortalName" />
                    <telerik:GridBoundColumn DataField="ExpiryDate" HeaderText="Expires" UniqueName="ExpiryDate" />
                    <telerik:GridBoundColumn DataField="AutoDeleteDate" HeaderText="Auto-Delete Date"
                        UniqueName="AutoDeleteDate" Visible="False" />
                    <telerik:GridBoundColumn DataField="PortalId" HeaderText="Portal ID" ReadOnly="true"
                        UniqueName="PortalId" />
                    <telerik:GridDropDownColumn DataField="MembershipProviderName" DropDownControlType="RadComboBox" HeaderText="Authentication"
                        UniqueName="membershipProviders" ReadOnly="false" ListValueField="MembershipProviderName" ListTextField="MembershipProviderName" ListDataMember="MembershipProviderName">
                    </telerik:GridDropDownColumn>
                    <telerik:GridCheckBoxColumn DataField="HTTPS" HeaderText="HTTPS" UniqueName="https">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridHyperLinkColumn Text="Portal URLs" DataNavigateUrlFields="PortalId"
                        DataNavigateUrlFormatString="EditPortal.aspx?return=portals&pid={0}" />
                    <telerik:GridBoundColumn DataField="ThemeName" HeaderText="Theme" UniqueName="ThemeName"
                        ReadOnly="true" />
                    <telerik:GridTemplateColumn UniqueName="DeleteColumn">
                        <ItemStyle Width="12px" />
                        <ItemTemplate>
                            <asp:ImageButton ID="btn1" ImageUrl="~/Images/Admin Icons/delete16.png" Width="14"
                                Height="14" runat="server" CommandArgument='<%# DataBinder.Eval ( Container.DataItem, "PortalId" ) %>'
                                OnCommand="confirmButton_Clicked" />
                            <ajaxToolkit:ConfirmButtonExtender ID="cfe1" runat="server" TargetControlID="btn1"
                                ConfirmText='<%# GetDeleteConfirmMessage(DataBinder.Eval (Container.DataItem, "PortalName").ToString()) %>' />
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                </Columns>
            </MasterTableView>
        </telerik:RadGrid>


        <br />
        <asp:Label ID="PortalsUsedLabel" runat="server" Text="Portals Used: "></asp:Label>
        <div runat="server" id="addNewDiv">
            <h3>
                <asp:Label ID="AddNewPortalLabel" runat="server" Text="Add A New Portal"></asp:Label></h3>
            <table cellpadding="5px">
                <tr>
                    <td>
                        <asp:Label ID="nameLabel" Text="Portal Name" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="nameTextBox" />
                        <asp:RequiredFieldValidator ID="nameRequiredFieldValidator" EnableClientScript="true"
                            ValidationGroup="Add" runat="server" ControlToValidate="nameTextBox" ErrorMessage="A Portal Name is required."
                            Text="*"></asp:RequiredFieldValidator>
                    </td>
                    <td>
                        <asp:Label ID="urlLabel" Text="Portal URL" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="urlTextBox" /><asp:RequiredFieldValidator
                            ID="urlRequiredFieldValidator" EnableClientScript="true" ValidationGroup="Add"
                            runat="server" ControlToValidate="urlTextBox" ErrorMessage="A Portal URL is required."
                            Text="*"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="adminUsernameLabel" Text="Admin UserName" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="adminUsernameTextBox" />
                        <asp:RequiredFieldValidator ID="adminUsernameRequiredFieldValidator" EnableClientScript="true"
                            ValidationGroup="Add" runat="server" ControlToValidate="adminUsernameTextBox"
                            ErrorMessage="An Admin Username is required." Text="*"></asp:RequiredFieldValidator>
                    </td>
                    <td>
                        <asp:Label ID="adminEmailLabel" Text="Admin Email" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="adminEmailTextBox" /><asp:RequiredFieldValidator
                            ID="EmailRequiredFieldValidator" EnableClientScript="true" ValidationGroup="Add"
                            runat="server" ControlToValidate="adminEmailTextBox" Text="*" ErrorMessage="An Admin Email is required."></asp:RequiredFieldValidator><asp:RegularExpressionValidator
                                ID="ValidEmailExpressionValidator" runat="server" ControlToValidate="adminEmailTextBox"
                                ErrorMessage="The Admin Email address is not valid." Text="*" ValidationGroup="Add"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="adminPasswordLabel" Text="Admin Password" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="adminPasswordTextBox" TextMode="Password" />
                        <asp:RequiredFieldValidator ID="adminPasswordRequiredFieldValidator" EnableClientScript="true"
                            ValidationGroup="Add" runat="server" ControlToValidate="adminPasswordTextBox"
                            ErrorMessage="A Password is required." Text="*"></asp:RequiredFieldValidator>
                    </td>
                    <td>
                        <asp:Label ID="ConfirmPasswordLabel" Text="Confirm Password" runat="server" />
                    </td>
                    <td>
                        <telerik:RadTextBox runat="server" ID="ConfirmPasswordTextbox" TextMode="Password" />
                        <asp:RequiredFieldValidator ID="ConfirmPasswordRequiredFieldValidator" EnableClientScript="true"
                            ValidationGroup="Add" runat="server" ControlToValidate="ConfirmPasswordTextbox"
                            ErrorMessage="The password must be confirmed." Text="*" Visible="false"></asp:RequiredFieldValidator>
                        <asp:CompareValidator ID="PasswordCompareValidator" runat="server" ControlToValidate="adminPasswordTextBox"
                            ControlToCompare="ConfirmPasswordTextbox" ValidationGroup="Add" ErrorMessage="The passwords do not match."
                            Text="*"></asp:CompareValidator>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="clonePortalLabel" runat="server" Text="Apply look and feel from"></asp:Label>
                    </td>
                    <td>
                        <telerik:RadComboBox ID="clonePortalDropDown" runat="server" Width="160">
                        </telerik:RadComboBox>
                    </td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="PortalExpiryDateLabel" Text="Expiry Date" runat="server" />
                    </td>
                    <td>
                        <telerik:RadDatePicker ID="ExpiryDatePicker" runat="server" Width="160">
                        </telerik:RadDatePicker>
                    </td>
                    <td>
                        <%--<asp:Label ID="PortalAutoDeleteLabel" Text="Auto-Delete Date" runat="server" />--%>
                    </td>
                    <td>
                        <%-- <telerik:RadDatePicker ID="AutoDeleteDatePicker" runat="server">
                    </telerik:RadDatePicker>--%>
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <asp:ValidationSummary ID="valSummary" runat="server" DisplayMode="List" ShowMessageBox="false"
                            ShowSummary="true" ValidationGroup="Add" />
                        <asp:Label runat="server" ID="portalExistsLabel" Text="Portal or url already exists"
                            CssClass="error" />
                        <asp:Label runat="server" ID="PortalNameLengthError" Text="The portal name can be no more than 20 characters."
                            CssClass="error" Visible="false" EnableViewState="false" />
                        <asp:Label runat="server" ID="autoDeletCompulsaryLabel" Text="You must choose an auto delete date"
                            CssClass="error" Visible="false" EnableViewState="false" />
                        <asp:Label runat="server" ID="expiryDateCompulsaryLabel" Text="You must choose an expiry date"
                            CssClass="error" Visible="false" EnableViewState="false" />
                    </td>
                </tr>
            </table>
            <asp:Label runat="server" ID="ErrorMessage" Text=""></asp:Label>
        </div>
    
    <ep:AdminFooter ID="AdminFooter1" runat="server" SubmitButtontext="Add" ValidationGroup="Add"
        CauseValidation="true" />
    <%--<br />
    <br />
    <br />
    <br />
    <br />
    <div style="display: none;">
        <br />
    </div>--%>
</asp:Content>
