<%@ control language="C#" autoeventwireup="true" inherits="Eprint.Skyline.Web.Controls.WebControls_orders, App_Web_t2oo5a1r" %>
<%@ Register Src="PortalSelector.ascx" TagName="PortalSelector" TagPrefix="uc2" %>
<%@ Register TagPrefix="ajaxToolkit" Namespace="AjaxControlToolkit" Assembly="AjaxControlToolkit, Version=3.5.51116.0, Culture=neutral, PublicKeyToken=28f01b0e84b6d53e" %>
<script type="text/javascript">
    function openWindow(ID) {
        var manager = GetRadWindowManager();
        var win = manager.GetWindowByName('OrderPreview');
        win.SetUrl("/orderDetailPreview.aspx?ID=" + ID, "Order Details");
        win.Show();
    }

    function showJDF(ID) {
        var manager = GetRadWindowManager();
        var win = manager.GetWindowByName('JDF');
        win.SetUrl("/jdfPreview.aspx?ID=" + ID, "JDF Preview");
        win.Show();
    }

    //Standard Window.confirm
    function StandardConfirm(sender, args) {
        args.set_cancel(!window.confirm("Are you sure you want to delete this order?"));
    }
</script>
<style>
    
    .RadAjax .raDiv
    {
        background: url(/images/ajax-loader.gif) no-repeat center center;
    }
    
    div.RadGrid_Default .rgHeader
    {
        border-right: 1px solid #828282;
    }

    .RadButton .rbPrimary {
        padding-left: 8px;
    }
</style>
<asp:HiddenField runat="server" ID="QuoteSentId"/>
<asp:HiddenField runat="server" ID="OrderPlacedId"/>
<uc2:PortalSelector ID="PortalSelector1" runat="server" DisplayType="Orders" AutoPostBack="true"
    OnSelectionChanged="PortalSelector_OnSelectionChanged" />
<br />
<asp:Label ID="OrderStatusLabel" runat="server" SkinID="NoTrans">View Orders</asp:Label>&nbsp;
<telerik:RadComboBox ID="OrderStatusDropDown" AutoPostBack="true" runat="server"
    TabIndex="1" OnSelectedIndexChanged="OrderStatus_SelectedIndexChanged">
</telerik:RadComboBox>
<br />
<div class="row">
    <asp:Label ID="numOrdersLabel" runat="server" Text="Number of orders per page" SkinID="NoTrans" />&nbsp;
    <telerik:RadComboBox Width="50px" ID="PageSizeCombo" AutoPostBack="true" runat="server"
                         TabIndex="1" OnSelectedIndexChanged="PageSizeCombo_SelectedIndexChanged">
    </telerik:RadComboBox>
</div>


<telerik:RadAjaxLoadingPanel ID="RadAjaxLoadingPanel1" runat="server" Skin="Default"
    BackColor="White" Transparency="50">
</telerik:RadAjaxLoadingPanel>
<telerik:RadAjaxManager ID="RadAjaxManager1" runat="server" DefaultLoadingPanelID="RadAjaxLoadingPanel1">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="PageSizeCombo">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RadGrid1" LoadingPanelID="RadAjaxLoadingPanel1" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="RadGrid1">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RadGrid1" LoadingPanelID="RadAjaxLoadingPanel1"
                    UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManager>
<telerik:RadGrid ID="RadGrid1" runat="server"
    AutoGenerateColumns="false" OnNeedDataSource="RadGrid1_NeedDataSource" EnableAJAX="true"
    AllowPaging="true" PagerStyle-Mode="NextPrevAndNumeric" PageSize="20" AllowMultiRowSelection="false"
    AllowSorting="true" EnableLinqExpressions="false" 
    onitemdatabound="RadGrid1_ItemDataBound" OnPreRender="RadGrid1_PreRender" OnItemCommand="RadGrid1_ItemCommand">
<%--<GroupingSettings CollapseAllTooltip="Collapse all groups"></GroupingSettings>--%>

    <ClientSettings>
        <%--<Selecting AllowRowSelect="True"></Selecting>--%>
        <%--<Resizing AllowRowResize="True" EnableRealTimeResize="True" AllowColumnResize="True">
        </Resizing>--%>
        <Resizing AllowColumnResize="True">
        </Resizing>
    </ClientSettings>
    <AlternatingItemStyle BackColor="#F0F0F0" />
    <MasterTableView DataKeyNames="OrderDetailId, OrderId, OrderDetailStatusId, Price, DocumentId" AllowMultiColumnSorting="True">
       <%-- CommandItemDisplay="Top">--%>
        <%--<CommandItemTemplate>
            <div style="display: table">
                <div style="display: table-cell; vertical-align: middle; padding: 4px;">
                    <asp:ImageButton ID="btn1" ImageUrl="~/Images/Delete_Button.png" runat="server" CommandArgument='<%# DataBinder.Eval( Container.DataItem, "DocumentId") %>'
                        CommandName="Delete" OnCommand="DeleteSelectedButton_Clicked" />
                    <ajaxToolkit:ConfirmButtonExtender ID="cfe1" runat="server" TargetControlID="btn1"
                        ConfirmText="Delete selected orders?" />
                </div>
                <div style="display: table-cell; vertical-align: middle;">
                    <asp:Label ID="deleteUsersLabel" runat="server" Text="Delete Selected Orders" Height="22px"></asp:Label>
                </div>
            </div>
        </CommandItemTemplate>--%>
        <Columns>
            <%--<telerik:GridClientSelectColumn UniqueName="ClientSelectColumn" />--%>
            <telerik:GridTemplateColumn UniqueName="Download" HeaderText="PDF" HeaderTooltip="Download document">
                <HeaderStyle Width="35"></HeaderStyle>
                <ItemTemplate>
                    <asp:HyperLink runat="server" ID="lnkDownload"  />
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridTemplateColumn HeaderText="Job Ticket" HeaderTooltip="View Job Ticket">
                <HeaderStyle Width="70px" />
                <ItemTemplate>
                    <input type="button" onclick="window.open('/Printstation/Jobticket.aspx?orderDetailId=<%#DataBinder.Eval(Container.DataItem,"OrderDetailId")%>&Pid=<%=PortalId%>','_blank','width=750, height=400, toolbar=0, scrollbars=yes')"
                        value="<%# Eprint.Skyline.Translations.Common.View%>" />
                    
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <%--<telerik:GridTemplateColumn UniqueName="JDF">
                <ItemTemplate>
                    <a href="#" onclick='window.open("/Printstation/Jobticket.aspx?orderDetailId=<%#DataBinder.Eval(Container.DataItem,"OrderDetailId")%>&Pid=<%=PortalId%>","","width=750, height=400, toolbar=0, scrollbars=yes,");'>
                        view jdf</a>
                </ItemTemplate>
            </telerik:GridTemplateColumn>--%>
            <telerik:GridBoundColumn DataField="DocumentName" HeaderText="Document" ReadOnly="true" HeaderTooltip="Document Name"
                UniqueName="DocumentName" />
           
            <telerik:GridBoundColumn DataField="ShortOrderID" HeaderText="Order Number" ReadOnly="true" HeaderTooltip="Order Number" 
                UniqueName="OrderID">
                
            </telerik:GridBoundColumn>
            
            <telerik:GridBoundColumn DataField="OrderDate" HeaderText="Order Date" UniqueName="OrderDate" DataFormatString="{0:g}" HeaderTooltip="Order Date" >
            </telerik:GridBoundColumn>

            <telerik:GridBoundColumn DataField="DateRequired" HeaderText="Date Required" UniqueName="DateRequired" DataFormatString="{0:d}" HeaderTooltip="Date Required">
            </telerik:GridBoundColumn>

            <telerik:GridTemplateColumn DataField="StatusName" HeaderText="Status" UniqueName="StatusName" HeaderTooltip="Current Job Status">
                <ItemTemplate>
                    <asp:Label runat="server" ID="UxStatusName" Text=<%# getStatusName((string)DataBinder.Eval(Container.DataItem, "StatusName"), (string)DataBinder.Eval(Container.DataItem, "EnduserDisplay"), (bool)DataBinder.Eval(Container.DataItem, "ShowUser"))%>>

                    </asp:Label>
                    
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridTemplateColumn DataField="orderDetailsState" HeaderText="Approval Status" HeaderTooltip="Approval Status"
                UniqueName="Approval">
                <HeaderStyle Width="140px" />
                <ItemTemplate>
                    <%# GetApprovalStatus(DataBinder.Eval(Container.DataItem, "orderDetailID"))%>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridBoundColumn DataField="BillingCode" HeaderText="BillingCode" UniqueName="BillingCode" Visible="False" />
            <telerik:GridBoundColumn DataField="BillingCodeName" HeaderText="BillingCodeName" UniqueName="BillingCodeName" Visible="False" />
            <telerik:GridTemplateColumn HeaderText="Quote" HeaderTooltip="Add Quote to basket">
                <HeaderStyle Width="50px" />
                <ItemTemplate>
                    <telerik:RadButton runat="server" ID="AcceptButton" Text="" CommandName="AddToBacket" Visible='<%# ShowAccept(DataBinder.Eval(Container.DataItem, "orderDetailStatusID")) %>'
                                       CommandArgument='<%# DataBinder.Eval(Container.DataItem,"OrderDetailId") %>' ToolTip="<%# Eprint.Skyline.Translations.Common.AddToBasket%>">
                        <Icon PrimaryIconUrl="~/images/Admin Icons/approval-default-16.png" PrimaryIconTop="3px" PrimaryIconLeft="4px"></Icon>
                    </telerik:RadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>

            <telerik:GridTemplateColumn UniqueName="UserDeleteColumn" HeaderTooltip="Delete Order" HeaderText="Delete">
                <HeaderStyle Width="50px" />
                <ItemTemplate>
                    <telerik:RadButton runat="server" ID="btn1" Text="" ToolTip="<%# Eprint.Skyline.Translations.Common.Delete%>" CommandArgument='<%# DataBinder.Eval( Container.DataItem, "OrderDetailId") + "," + DataBinder.Eval(Container.DataItem, "orderID")+ "," + DataBinder.Eval(Container.DataItem, "orderDetailStatusID") %>'
                                       OnClientClicking="StandardConfirm"
                                       OnCommand="confirmButton_Clicked" Visible='<%# ShowDelete(DataBinder.Eval(Container.DataItem, "orderDetailStatusID") + "," + DataBinder.Eval(Container.DataItem, "orderID") + "," + DataBinder.Eval(Container.DataItem, "BillingCode")) %>'>
                        <Icon PrimaryIconUrl="~/Images/Delete.gif"></Icon>
                    </telerik:RadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
        </Columns>
    </MasterTableView>
</telerik:RadGrid>
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
    <triggers>
        <asp:AsyncPostBackTrigger ControlID="PageSizeCombo" EventName="SelectedIndexChanged" />
    </triggers>
</telerik:RadAjaxPanel>
